class Balloon_big_green extends Balloon;


var sound FireSound;
var Class<Projectile> ProjectileType;
var bool bInit;

function Shoot(Pawn Target)
{
local Vector FireSpot, ProjStart;
local Projectile p;

	PlaySound(FireSound, SLOT_None,5.0);

	ProjStart = Location;
	FireSpot = Target.Location + FMin(1, 0.7 + 0.6 * FRand()) * (Target.Velocity * VSize(Target.Location - ProjStart)/ProjectileType.Default.Speed);
	if ( !FastTrace(FireSpot, ProjStart) )
			FireSpot = 0.5 * (FireSpot + Target.Location);
	DesiredRotation = Rotator(FireSpot - ProjStart);
	p = Spawn (ProjectileType,,,ProjStart,DesiredRotation);
}

state TacticalMove
{
ignores SeePlayer, HearNoise;

	function SetFall()
	{
	}

	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, Vector momentum, name damageType)
		{
		Global.TakeDamage(Damage, instigatedBy, hitlocation, momentum, damageType);
		if ( !bInit )
			{
			SetTimer(3.0,True);
			bInit = True;
			}
		if ( health <= 0 )
			return;
		if ( NextState == 'TakeHit' )
			{
			NextState = 'TacticalMove'; 
			NextLabel = 'TakeHit';
			GotoState('TakeHit'); 
			}
		}

	function HitWall(vector HitNormal, actor Wall)
	{
	}

	function FearThisSpot(Actor aSpot)
	{
	}

	function AnimEnd() 
	{
	}

	function Timer()
	{
	local Pawn P;
	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
		{
		if ( P.IsA('PlayerPawn') )
			{
			//if ( Vsize(P.Location - Location) < 800 )
			Shoot(P);
			}
		}
	}

	function EnemyNotVisible()
	{
	}

	function bool ValidRecovery()
	{
	}
		
	function GiveUpTactical(bool bNoCharge)
	{	
	}		

/* PickDestination()
Choose a destination for the tactical move, based on aggressiveness and the tactical
situation. Make sure destination is reachable
*/
	function PickDestination(bool bNoCharge)
	{
	if ( Route == 1 )
		{
		DesiredRotation = Rotator(PathNodeA[PathNum].Location - Location);
		Focus = PathNodeA[PathNum].Location;
		Destination = PathNodeA[PathNum].Location;
		}
	else if ( Route == 2 )
		{
		DesiredRotation = Rotator(PathNodeB[PathNum].Location - Location);
		Focus = PathNodeB[PathNum].Location;
		Destination = PathNodeB[PathNum].Location;
		}
	else if ( Route == 3 )
		{
		DesiredRotation = Rotator(PathNodeC[PathNum].Location - Location);
		Focus = PathNodeC[PathNum].Location;
		Destination = PathNodeC[PathNum].Location;
		}
	else if ( Route == 4 )
		{
		DesiredRotation = Rotator(PathNodeD[PathNum].Location - Location);
		Focus = PathNodeD[PathNum].Location;
		Destination = PathNodeD[PathNum].Location;
		}
	}

	function BeginState()
	{
	}
	
	function EndState()
	{
	}

//FIXME - what if bReadyToAttack at start
TacticalTick:
	Sleep(0.02);	
Begin:
	PickDestination(false);

DoMove:
	MoveTo(Destination);
	
NoCharge:
	if ( Route == 1 )
		{
		DesiredRotation = Rotator(PathNodeA[PathNum].Location - Location);
		Focus = PathNodeA[PathNum].Location;
		Destination = PathNodeA[PathNum].Location;
		}
	else if ( Route == 2 )
		{
		DesiredRotation = Rotator(PathNodeB[PathNum].Location - Location);
		Focus = PathNodeB[PathNum].Location;
		Destination = PathNodeB[PathNum].Location;
		}
	else if ( Route == 3 )
		{
		DesiredRotation = Rotator(PathNodeC[PathNum].Location - Location);
		Focus = PathNodeC[PathNum].Location;
		Destination = PathNodeC[PathNum].Location;
		}
	else if ( Route == 4 )
		{
		DesiredRotation = Rotator(PathNodeD[PathNum].Location - Location);
		Focus = PathNodeD[PathNum].Location;
		Destination = PathNodeD[PathNum].Location;
		}
	Goto('DoMove');
	
AdjustFromWall:
	StrafeTo(Destination, Focus); 
	Destination = Focus; 
	Goto('DoMove');

TakeHit:
	Goto('DoMove');

RecoverEnemy:
	MoveTo(Destination);
	Goto('DoMove');
}

defaultproperties
{
	 layers=450
	 health=450
	 speed=1.400000
     AmbientGlow=64
	 DrawType=DT_Mesh
	 Mesh=Mesh'BigBalloon'
	 DrawScale=0.250000
	 CollisionRadius=64.00000
	 CollisionHeight=152.00000
	 MultiSkins(0)=Texture'PopBalloonsTextures.Colors.cGreenBigOne'
	 MultiSkins(1)=Texture'PopBalloonsTextures.Misc.basket'
	 MultiSkins(2)=Texture'PopBalloonsTextures.Colors.cBlack'
	 ProjectileType=Class'BigRedShot'
	 FireSound=Sound'UnrealI.Cannon.CannonShot'
}
